(* ::Package:: *)

%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%    The finite element-based mesh warping code, i.e., FEMWARP code, is in the
%    public domain and may be distributed freely. 
%    Authors:  Suzanne M. Shontz, The Pennsylvania State University, and 
%    Stephen A. Vavasis, University of Waterloo, (shontz@cse.psu.edu).  December 2010.
%    This code was developed while Shontz was a Ph.D. student in Vavasis's research group
%    at Cornell University. 

% Script to compute the weights using discretization of Laplace's
% equation.
close all, clear all, clc;
warning off;

% Get input
filebase=input('Enter the name of the mesh:  ');

% Read-in initial mesh
mesh=readmesh2(filebase);
h= figure; 
% REMOVE SUBPLOT
% subplot(1,2,1);
drawmesh2(mesh,1,'I');
print(h, '-dpdf', 'hb_pre'); 
saveas(gcf, 'hb_pre', 'eps2c');
% REMOVE NEXT TWO LINES.
% axis([-0.5 2 0 3]);
% axis off;
inverted = evalquality2(mesh,filebase,1,1);

% Number of nodes
n = length(mesh.coords);

% Determine interior nodes
interior = find(mesh.border < 1);
counter = length(interior);
i = counter;

% Determine boundary nodes
boundary = find(mesh.border > 0);
b = length(boundary);

% Malloc space for A.
A = zeros(i+b,i+b);

% Global ordering for nodes.
glbal = [interior' boundary'];

% Compute local stiffness matrices and then assemble then into 
% global stiffness matrix.

for k=1:length(mesh.tris)
  mytris = mesh.tris(k,:);

  g1 = find(glbal == mytris(1));
  g2 = find(glbal == mytris(2));
  g3 = find(glbal == mytris(3));

  x = mesh.coords(mytris,1);
  y = mesh.coords(mytris,2);

  x1 = x(1);
  y1 = y(1);

  x2 = x(2);
  y2 = y(2);
 
  x3 = x(3);
  y3 = y(3);

  % Compute phi1, phi2, phi3.
  denom = x3*y1-x3*y2-x2*y1-x1*y3+x1*y2+x2*y3;

  m1 = (-y3+y2)/denom;
  n1 = -(x2-x3)/denom;

  m2 = (-y1+y3)/denom;
  n2 = (-x3+x1)/denom;

  m3 = -(-y1+y2)/denom;
  n3 = -(x1-x2)/denom;

  v1 = [m1; n1];
  v2 = [m2; n2];
  v3 = [m3; n3];

  % Compute delta.
  delta = abs(det([x1 y1 1; x2 y2 1; x3 y3 1]));

  % Compute dot products of gradients.
  A(g1,g1) = A(g1,g1)+dot(v1,v1)*0.5*delta;
  A(g1,g2) = A(g1,g2)+dot(v1,v2)*0.5*delta;
  A(g1,g3) = A(g1,g3)+dot(v1,v3)*0.5*delta;
  A(g2,g2) = A(g2,g2)+dot(v2,v2)*0.5*delta;
  A(g2,g3) = A(g2,g3)+dot(v2,v3)*0.5*delta;
  A(g3,g3) = A(g3,g3)+dot(v3,v3)*0.5*delta;
  A(g2,g1) = A(g1,g2);
  A(g3,g1) = A(g1,g3);
  A(g3,g2) = A(g2,g3);


 
end;

% sparse(A(1:i, i+1:end));
% variable = zeros(i+b);
% for j=1:i+b    
%     tmp_x = mesh.coords(glbal(j),1);
%     tmp_y = mesh.coords(glbal(j),2);
%     X = [tmp_x, tmp_y];
%     Y = [0, 0]';
%     tmp = dist(X,Y);
%     if(tmp < 1) 
%         variable(j) = 0.96;
%     elseif(tmp < 2 && tmp >= 1)
%         variable(j) = 0.97;
%     elseif(tmp < 3 && tmp >= 2)
%         variable(j) = 0.98;
%     else
%         variable(j) = 0.99;
%     end
%    
%     A(j,1:j-1) = A(j,1:j-1)*variable(j);
%     A(j,j+1:end) = A(j, j+1:end)*variable(j);
% end
    
sparse(A(1:i, i+1:end));
A_I = A(1:i,1:i);
A_B = A(1:i,i+1:end);


sparse(A_B);
clear A;

% Move mesh
%%%%% JP initial
mesh_ 1 = readmesh2('init_to _inter _lsm _boundary');
vec_node = length(mesh_ 1.coords);
vec_boundary _in = find(mesh_ 1.border == 1);
vec_boundary = find(mesh_ 1.border > 0);
vec_myx = mesh_ 1.coords(vec_boundary _in,1);
vec_myy = mesh_ 1.coords(vec_boundary _in,2);
newmesh = mesh_ 1;
ele=length(newmesh.tris);
node=length(newmesh.coords);
%%%%%%%%%

%% new try
% newmesh = mesh;
% ele = length(newmesh.tris);
% node = length(newmesh.coords);
% boundary_in = find(newmesh.border == 2);
% boundary_out = find(newmesh.border == 1);
% boundary = find(newmesh.border > 0);

% Transformation used for brain image
% outside boundary first
% myx = newmesh.coords(boundary_out,1) ;
% myy = newmesh.coords(boundary_out,2) ;
% newmesh.coords(boundary_out,1) = myx;
% newmesh.coords(boundary_out,2) = myy;
% myx = newmesh.coords(boundary_out,1);
% myy = newmesh.coords(boundary_out,2);
% newmesh.coords(boundary_out,1) = myx;
% newmesh.coords(boundary_out,2) = myy;

% inside boundary 
% myx = newmesh.coords(boundary_in,1);
% myy = newmesh.coords(boundary_in,2);

% vertice = size(myx);
% for i=1:vertice
%     if(myy(i) > 0)
%         if(myx(i) < 0)
%             newmesh.coords(boundary_in(i),1) = myx(i)*0.73 + 1*88;
%             newmesh.coords(boundary_in(i),2) = myy(i)*0.74 + 1*100;
%         else
%             newmesh.coords(boundary_in(i),1) = myx(i)*0.84 + 1*88;
%             newmesh.coords(boundary_in(i),2) = myy(i)*0.87 + 1*100;
%         end
%     else
%         if(myx(i) < 0)
%             newmesh.coords(boundary_in(i),1) = myx(i)*0.94 + 1*88;
%             newmesh.coords(boundary_in(i),2) = myy(i)*0.94 + 1*100;
%         else
%             newmesh.coords(boundary_in(i),1) = myx(i)*0.95 + 1*88;
%             newmesh.coords(boundary_in(i),2) = myy(i)*0.95 + 1*100;
%         end
%     end
%     
% end

% for i=1:vertice
%     if(myy(i) > 0)
%         if(myx(i) < 0) %4
%             newmesh.coords(boundary_in(i),1) = vec_myx(i)*1.013 + 1*88;
%             newmesh.coords(boundary_in(i),2) = vec_myy(i)*1.013 + 1*97;
%         else  %1
%             newmesh.coords(boundary_in(i),1) = vec_myx(i)*1.12 + 1*88;
%             newmesh.coords(boundary_in(i),2) = vec_myy(i)*1.12 + 1*97;
%         end
%     else
%         if(myx(i) < 0) %3
%             newmesh.coords(boundary_in(i),1) = vec_myx(i)*0.98 +  1*88;
%             newmesh.coords(boundary_in(i),2) = vec_myy(i)*1.0 +  1*97;
%         else %2
%             newmesh.coords(boundary_in(i),1) = vec_myx(i)*1.0 + 1*88;
%             newmesh.coords(boundary_in(i),2) = vec_myy(i)*1.0 + 1*97;
%         end
%     end
% end

newmesh.coords(vec_boundary _in,1) = vec_myx;
newmesh.coords(vec_boundary _in,2) = vec_myy;


% Draw tangled mesh
% figure;
% drawmesh2(newmesh,2,'T');
% inverted  = evalquality2(newmesh,filebase,2,0);

% Solve linear system
A_I = sparse(A_I);
R = chol(A_I);
A_B = sparse(A_B);
b = -A_B*[newmesh.coords(boundary,1) newmesh.coords(boundary,2)];
solution = R\(R'\(b));
% solution = U\(U'\(b));
newmesh.coords(interior,1) = solution(:,1);
newmesh.coords(interior,2) = solution(:,2);

% Draw final mesh
% figure;
% TAKE THIS LINE OUT!!!!
% hold on;
% axis off;
% subplot(1,2,2);
h = figure;
drawmesh2(newmesh,3,'L');
print(h, '-dpdf', 'hb_post');
saveas(gcf, 'hb_post', 'eps2c');
% axis([-0.5 2 0 3]);
% axis off;
inverted = evalquality2(newmesh,'hb_post',3,1);

% Write out final mesh
write_meshfiles(newmesh.coords,newmesh.tris,newmesh.border,'output_mesh');
